<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApprovalWorkflow extends Model 
{

    protected $table = 'approval_workflows';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('comments', 'approval_status', 'approver_id', 'panel_id');

    public function panel()
    {
        return $this->belongsTo('App\Models\Panel');
    }

    public function approver()
    {
        return $this->belongsTo('App\Models\User');
    }

}